//GEMINI-pro DATASET v1.0 Category: Recursive ; Style: imaginative
#include <stdio.h>

// The mystical tree of recursion, where functions call themselves to unravel secrets.

// A recursive function to calculate the factorial of a number.
// Each call descends deeper into the tree, until it reaches the base case of n == 1,
// then it ascends back up, multiplying the results at each level.
int factorial(int n) {
  if (n == 1) {
    return 1;
  } else {
    return n * factorial(n - 1);  // Recursively call itself to dive deeper
  }
}

// A recursive function to print a sequence of numbers in reverse order.
// Each call prints a number and then calls itself to print the next smaller number.
void printReverse(int n) {
  if (n > 0) {
    printf("%d ", n);
    printReverse(n - 1);  // Recursively call itself to go smaller
  }
}

// A recursive function to find the maximum element in an array.
// Each call compares two elements and selects the larger one, then calls itself
// on the remaining array to find the maximum from the smaller portion.
int findMax(int arr[], int n) {
  if (n == 2) {
    return arr[0] > arr[1] ? arr[0] : arr[1];
  } else {
    int max = findMax(arr, n - 1);  // Recursively call itself on smaller portion
    return max > arr[n - 1] ? max : arr[n - 1];
  }
}

// A recursive function to check if a number is prime.
// Each call checks divisibility by a smaller number, until either it finds a divisor
// or reaches the square root of the number (beyond which no smaller divisors exist).
int isPrime(int n) {
  int divisor = 2;
  return isPrimeHelper(n, divisor);
}

int isPrimeHelper(int n, int divisor) {
  if (divisor * divisor > n) {
    return 1;
  } else if (n % divisor == 0) {
    return 0;
  } else {
    return isPrimeHelper(n, divisor + 1);  // Recursively call itself with next divisor
  }
}

int main() {
  int n = 5;
  printf("Factorial of %d: %d\n", n, factorial(n));
  printReverse(n);
  printf("\n");

  int arr[] = {1, 5, 3, 4, 2};
  printf("Maximum element in array: %d\n", findMax(arr, 5));

  if (isPrime(13)) {
    printf("13 is a prime number\n");
  } else {
    printf("13 is not a prime number\n");
  }

  return 0;
}