//MISTRAL-7B DATASET v1.0 Category: Unit converter ; Style: satisfied
#include <stdio.h>
#include <stdlib.h>

typedef struct {
    float value;
    char unit;
} Unit;

Unit convert(Unit base, Unit to, float conversionFactor) {
    Unit result;

    result.value = base.value * conversionFactor;
    result.unit = to.unit;

    return result;
}

void printUnit(Unit unit) {
    switch (unit.unit) {
        case 'm':
            printf("%.2f meters\n", unit.value);
            break;
        case 'cm':
            printf("%.2f centimeters\n", unit.value / 100.0);
            break;
        case 'kg':
            printf("%.2f kilograms\n", unit.value);
            break;
        case 'g':
            printf("%.2f grams\n", unit.value);
            break;
        case 'l':
            printf("%.2f liters\n", unit.value);
            break;
        case 'cl':
            printf("%.2f milliliters\n", unit.value);
            break;
        case 'F':
            printf("%.2f degrees Fahrenheit\n", unit.value * 5.0 / 9.0 + 32.0);
            break;
        case 'C':
            printf("%.2f degrees Celsius\n", unit.value);
            break;
        default:
            printf("Invalid unit\n");
            break;
    }
}

int main() {
    Unit lengthBase = { 2.5, 'm' };
    Unit lengthTo = { 0, 'cm' };
    Unit massBase = { 5.0, 'kg' };
    Unit massTo = { 0, 'g' };
    Unit temperatureBase = { 77.0, 'F' };
    Unit temperatureTo = { 0, 'C' };

    float lengthConversionFactor = 100.0;
    float massConversionFactor = 1000.0;
    float temperatureConversionFactorFtoC = 5.0 / 9.0;
    float temperatureConversionFactorCtoF = 9.0 / 5.0;

    Unit lengthResult = convert(lengthBase, lengthTo, lengthConversionFactor);
    Unit massResult = convert(massBase, massTo, massConversionFactor);
    Unit temperatureResultF = convert(temperatureBase, temperatureTo, temperatureConversionFactorFtoC);
    Unit temperatureResultC = convert(temperatureBase, temperatureTo, temperatureConversionFactorCtoF);

    printf("Length conversion:\n");
    printUnit(lengthResult);

    printf("Mass conversion:\n");
    printUnit(massResult);

    printf("Temperature conversion (Fahrenheit to Celsius):\n");
    printUnit(temperatureResultF);

    printf("Temperature conversion (Celsius to Fahrenheit):\n");
    printUnit(temperatureResultC);

    return 0;
}