//GEMINI-pro DATASET v1.0 Category: Temperature Converter ; Style: asynchronous
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <unistd.h>

// Define the temperature conversion functions
double fahrenheit_to_celsius(double fahrenheit) {
  return (fahrenheit - 32) * 5 / 9;
}

double celsius_to_fahrenheit(double celsius) {
  return (celsius * 9 / 5) + 32;
}

// Define the asynchronous temperature conversion function
void async_temperature_conversion(double temperature, char unit, char target_unit) {
  // Create a pipe to communicate with the child process
  int pipefd[2];
  if (pipe(pipefd) == -1) {
    perror("pipe");
    exit(EXIT_FAILURE);
  }

  // Fork a child process
  pid_t pid = fork();
  if (pid == -1) {
    perror("fork");
    exit(EXIT_FAILURE);
  }

  // Child process
  if (pid == 0) {
    // Close the read end of the pipe
    close(pipefd[0]);

    // Convert the temperature to the target unit
    double converted_temperature;
    if (unit == 'F') {
      converted_temperature = fahrenheit_to_celsius(temperature);
    } else if (unit == 'C') {
      converted_temperature = celsius_to_fahrenheit(temperature);
    } else {
      fprintf(stderr, "Invalid unit: %c\n", unit);
      exit(EXIT_FAILURE);
    }

    // Write the converted temperature to the pipe
    if (write(pipefd[1], &converted_temperature, sizeof(double)) == -1) {
      perror("write");
      exit(EXIT_FAILURE);
    }

    // Close the write end of the pipe
    close(pipefd[1]);

    // Exit the child process
    exit(EXIT_SUCCESS);
  }

  // Parent process
  else {
    // Close the write end of the pipe
    close(pipefd[1]);

    // Read the converted temperature from the pipe
    double converted_temperature;
    if (read(pipefd[0], &converted_temperature, sizeof(double)) == -1) {
      perror("read");
      exit(EXIT_FAILURE);
    }

    // Print the converted temperature
    printf("%f %c = %f %c\n", temperature, unit, converted_temperature, target_unit);

    // Close the read end of the pipe
    close(pipefd[0]);

    // Wait for the child process to finish
    int status;
    waitpid(pid, &status, 0);

    // Exit the parent process
    exit(EXIT_SUCCESS);
  }
}

int main() {
  // Seed the random number generator
  srand(time(NULL));

  // Generate a random temperature
  double temperature = (double)rand() / RAND_MAX * 100;

  // Generate a random unit
  char unit = (rand() % 2 == 0) ? 'F' : 'C';

  // Generate a random target unit
  char target_unit = (unit == 'F') ? 'C' : 'F';

  // Convert the temperature asynchronously
  async_temperature_conversion(temperature, unit, target_unit);

  return 0;
}