//GEMINI-pro DATASET v1.0 Category: Phone Book ; Style: Dennis Ritchie
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_NAME_LEN 32
#define MAX_NUM_LEN 16
#define MAX_CONTACTS 100

typedef struct {
    char name[MAX_NAME_LEN];
    char num[MAX_NUM_LEN];
} Contact;

Contact contacts[MAX_CONTACTS];
int num_contacts = 0;

void add_contact(const char *name, const char *num) {
    if (num_contacts == MAX_CONTACTS) {
        printf("Phone book full!\n");
        return;
    }

    strcpy(contacts[num_contacts].name, name);
    strcpy(contacts[num_contacts].num, num);
    num_contacts++;
}

void print_contacts() {
    for (int i = 0; i < num_contacts; i++) {
        printf("%s: %s\n", contacts[i].name, contacts[i].num);
    }
}

void search_contact(const char *name) {
    for (int i = 0; i < num_contacts; i++) {
        if (strcmp(contacts[i].name, name) == 0) {
            printf("%s: %s\n", contacts[i].name, contacts[i].num);
            return;
        }
    }

    printf("Contact not found!\n");
}

void delete_contact(const char *name) {
    for (int i = 0; i < num_contacts; i++) {
        if (strcmp(contacts[i].name, name) == 0) {
            for (int j = i; j < num_contacts - 1; j++) {
                contacts[j] = contacts[j + 1];
            }
            num_contacts--;
            return;
        }
    }

    printf("Contact not found!\n");
}

int main() {
    add_contact("John Doe", "555-1212");
    add_contact("Jane Doe", "555-1213");
    add_contact("John Smith", "555-1214");
    add_contact("Jane Smith", "555-1215");

    print_contacts();

    search_contact("John Doe");
    search_contact("Jane Smith");

    delete_contact("John Doe");
    delete_contact("Jane Doe");

    print_contacts();

    return 0;
}