//Falcon-180B DATASET v1.0 Category: Smart home light control ; Style: dynamic
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

// Define maximum number of lights and sensors
#define MAX_LIGHTS 10
#define MAX_SENSORS 10

// Define structure for light and sensor data
typedef struct {
    char name[20];
    int status;
    int brightness;
} Light;

typedef struct {
    char name[20];
    int status;
} Sensor;

// Initialize light and sensor arrays
Light lights[MAX_LIGHTS];
Sensor sensors[MAX_SENSORS];

// Function to turn on/off light
void lightControl(int lightIndex, int onOff) {
    if (onOff == 1) {
        lights[lightIndex].status = 1;
        lights[lightIndex].brightness = 100;
        printf("Light %s turned on.\n", lights[lightIndex].name);
    } else {
        lights[lightIndex].status = 0;
        lights[lightIndex].brightness = 0;
        printf("Light %s turned off.\n", lights[lightIndex].name);
    }
}

// Function to adjust light brightness
void brightnessControl(int lightIndex, int brightness) {
    if (brightness >= 0 && brightness <= 100) {
        lights[lightIndex].brightness = brightness;
        printf("Light %s brightness set to %d.\n", lights[lightIndex].name, lights[lightIndex].brightness);
    } else {
        printf("Invalid brightness value.\n");
    }
}

// Function to read light status
void readLightStatus(int lightIndex) {
    if (lights[lightIndex].status == 1) {
        printf("Light %s is on.\n", lights[lightIndex].name);
    } else {
        printf("Light %s is off.\n", lights[lightIndex].name);
    }
    printf("Brightness: %d\n", lights[lightIndex].brightness);
}

// Function to read sensor status
void readSensorStatus(int sensorIndex) {
    if (sensors[sensorIndex].status == 1) {
        printf("Sensor %s is active.\n", sensors[sensorIndex].name);
    } else {
        printf("Sensor %s is inactive.\n", sensors[sensorIndex].name);
    }
}

// Main function
int main() {
    // Initialize light and sensor arrays
    for (int i = 0; i < MAX_LIGHTS; i++) {
        strcpy(lights[i].name, "Light");
        sprintf(&lights[i].name[5], "%d", i+1);
        lights[i].status = 0;
        lights[i].brightness = 0;
    }
    for (int i = 0; i < MAX_SENSORS; i++) {
        strcpy(sensors[i].name, "Sensor");
        sprintf(&sensors[i].name[7], "%d", i+1);
        sensors[i].status = 0;
    }

    // Example usage
    lightControl(1, 1);
    brightnessControl(1, 75);
    readLightStatus(1);
    readSensorStatus(1);

    return 0;
}