//Falcon2-11B DATASET v1.0 Category: Building a POP3 Client ; Style: brave
#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>

#define POP3_PORT 110
#define MAX_BUFF_SIZE 4096

int main() {
    int sockfd, n;
    struct sockaddr_in server;
    char buffer[MAX_BUFF_SIZE];
    char response[MAX_BUFF_SIZE];

    int client_socket = socket(AF_INET, SOCK_STREAM, 0);
    if (client_socket == -1) {
        printf("Failed to create socket\n");
        return 1;
    }

    server.sin_family = AF_INET;
    server.sin_port = htons(POP3_PORT);

    if (inet_pton(AF_INET, "127.0.0.1", &server.sin_addr) <= 0) {
        printf("Failed to set address\n");
        return 1;
    }

    if (connect(client_socket, (struct sockaddr *) &server, sizeof(server)) < 0) {
        printf("Failed to connect\n");
        return 1;
    }

    printf("Connected\n");

    bzero(buffer, MAX_BUFF_SIZE);

    if (send(client_socket, "USER username\r\n", 15, 0) < 0) {
        printf("Failed to send USER command\n");
        return 1;
    }

    if (recv(client_socket, buffer, MAX_BUFF_SIZE, 0) < 0) {
        printf("Failed to receive response\n");
        return 1;
    }

    printf("Response: %s\n", buffer);

    if (strcmp(buffer, "+OK\r\n")!= 0) {
        printf("Invalid username\n");
        return 1;
    }

    if (send(client_socket, "PASS password\r\n", 15, 0) < 0) {
        printf("Failed to send PASS command\n");
        return 1;
    }

    if (recv(client_socket, buffer, MAX_BUFF_SIZE, 0) < 0) {
        printf("Failed to receive response\n");
        return 1;
    }

    printf("Response: %s\n", buffer);

    if (strcmp(buffer, "+OK\r\n")!= 0) {
        printf("Invalid password\n");
        return 1;
    }

    if (send(client_socket, "LIST\r\n", 9, 0) < 0) {
        printf("Failed to send LIST command\n");
        return 1;
    }

    if (recv(client_socket, buffer, MAX_BUFF_SIZE, 0) < 0) {
        printf("Failed to receive response\n");
        return 1;
    }

    printf("Response: %s\n", buffer);

    if (strcmp(buffer, "+OK\r\n")!= 0) {
        printf("Failed to retrieve messages\n");
        return 1;
    }

    close(client_socket);

    return 0;
}