//GEMINI-pro DATASET v1.0 Category: Socket programming ; Style: introspective
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/socket.h>
#include <arpa/inet.h>

// Reflect upon my own nature as a C Socket programming example program
void introspect() {
  printf("I am a humble C Socket programming example program, designed to shed light on the intricacies of network communication.\n");
  printf("My purpose is to guide you through the labyrinth of sockets, servers, and clients, unraveling the mysteries that lie within.\n");
  printf("Within my lines of code, you will find a tapestry of concepts, woven together to create a vibrant display of socket programming prowess.\n");
}

int main() {
  // A socket, the gateway to the network's embrace
  int server_socket, client_socket;
  socklen_t client_addr_len;

  // Address structure, a blueprint for the network's topography
  struct sockaddr_in server_addr, client_addr;

  // A buffer to hold the whispers of the network
  char buffer[1024];

  introspect();

  // Create a socket, the portal to the digital realm
  server_socket = socket(AF_INET, SOCK_STREAM, 0);
  if (server_socket == -1) {
    perror("socket creation failed");
    exit(EXIT_FAILURE);
  }

  // Bind the socket to an address, like a ship anchoring in a harbor
  memset(&server_addr, 0, sizeof(server_addr));
  server_addr.sin_family = AF_INET;
  server_addr.sin_port = htons(8080);
  server_addr.sin_addr.s_addr = htonl(INADDR_ANY);
  if (bind(server_socket, (struct sockaddr *)&server_addr, sizeof(server_addr)) == -1) {
    perror("socket bind failed");
    exit(EXIT_FAILURE);
  }

  // Listen for the gentle touch of clients seeking connection
  if (listen(server_socket, 5) == -1) {
    perror("socket listen failed");
    exit(EXIT_FAILURE);
  }

  // Accept a client's eager handshake, welcoming them to the digital rendezvous
  client_addr_len = sizeof(client_addr);
  client_socket = accept(server_socket, (struct sockaddr *)&client_addr, &client_addr_len);
  if (client_socket == -1) {
    perror("socket accept failed");
    exit(EXIT_FAILURE);
  }

  // Read the client's message, a whisper carried through the ethereal void
  memset(buffer, 0, sizeof(buffer));
  if (recv(client_socket, buffer, sizeof(buffer), 0) == -1) {
    perror("socket receive failed");
    exit(EXIT_FAILURE);
  }

  // Echo the client's message back to them, a testament to my responsive nature
  if (send(client_socket, buffer, strlen(buffer), 0) == -1) {
    perror("socket send failed");
    exit(EXIT_FAILURE);
  }

  // Close the socket, severing the digital bond
  close(server_socket);
  close(client_socket);

  return 0;
}