//Falcon-180B DATASET v1.0 Category: Physics simulation ; Style: introspective
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <time.h>
#include <GL/glut.h>
#include <GL/glu.h>
#include <GL/gl.h>

float xrot = 0, yrot = 0, zrot = 0;
float xmove = 0, ymove = 0, zmove = 0;

void init()
{
    glClearColor(0.0, 0.0, 0.0, 0.0);
    gluPerspective(45, (GLfloat)640/(GLfloat)480, 0.1, 50.0);
    glMatrixMode(GL_PROJECTION);
    glLoadIdentity();
    gluLookAt(0,0,5,0,0,0,0,1,0);
    glMatrixMode(GL_MODELVIEW);
    glLoadIdentity();
}

void display()
{
    glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
    glPushMatrix();
    glRotatef(xrot, 1, 0, 0);
    glRotatef(yrot, 0, 1, 0);
    glRotatef(zrot, 0, 0, 1);
    glTranslatef(xmove, ymove, zmove);
    glutSolidSphere(0.5, 20, 20);
    glPopMatrix();
    glFlush();
}

void keyboard(unsigned char key, int x, int y)
{
    switch(key)
    {
        case 'w':
            zmove += 0.1;
            break;
        case's':
            zmove -= 0.1;
            break;
        case 'a':
            xmove -= 0.1;
            break;
        case 'd':
            xmove += 0.1;
            break;
        case 'q':
            xrot += 1;
            break;
        case 'e':
            xrot -= 1;
            break;
        case 'r':
            yrot += 1;
            break;
        case 'f':
            yrot -= 1;
            break;
        case 't':
            zrot += 1;
            break;
        case 'g':
            zrot -= 1;
            break;
        default:
            break;
    }
    glutPostRedisplay();
}

int main(int argc, char** argv)
{
    glutInit(&argc, argv);
    glutInitDisplayMode(GLUT_DOUBLE | GLUT_RGB);
    glutInitWindowSize(640, 480);
    glutInitWindowPosition(0, 0);
    glutCreateWindow("Physics Simulation");
    init();
    glutDisplayFunc(display);
    glutKeyboardFunc(keyboard);
    glutMainLoop();
    return 0;
}