//Falcon2-11B DATASET v1.0 Category: TCP/IP Programming ; Style: recursive
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <string.h>
#include <unistd.h>

void send_message(int sockfd, char *msg) {
    int n;
    n = write(sockfd, msg, strlen(msg));
    if (n < 0) {
        perror("write");
        exit(1);
    }
    if (n!= strlen(msg)) {
        printf("ERROR: Only %d bytes written out of %d\n", n, strlen(msg));
        exit(1);
    }
}

int main(int argc, char *argv[]) {
    int sockfd, n;
    struct sockaddr_in server_addr;
    char buffer[100];

    // Create socket
    sockfd = socket(AF_INET, SOCK_STREAM, 0);
    if (sockfd < 0) {
        perror("ERROR opening socket");
        exit(1);
    }

    // Set up server address
    server_addr.sin_family = AF_INET;
    server_addr.sin_port = htons(5000);
    server_addr.sin_addr.s_addr = inet_addr("127.0.0.1");

    // Connect to server
    if (connect(sockfd, (struct sockaddr *)&server_addr, sizeof(server_addr)) < 0) {
        perror("ERROR connecting");
        exit(1);
    }

    // Send message
    send_message(sockfd, "Hello, World!");

    close(sockfd);
    return 0;
}