//Falcon-180B DATASET v1.0 Category: Cafe Billing System ; Style: Linus Torvalds
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_ITEMS 100
#define MAX_CUSTOMERS 1000

typedef struct {
    int id;
    char name[50];
    float balance;
} Customer;

typedef struct {
    int id;
    char name[50];
    float price;
} Item;

typedef struct {
    int id;
    char name[50];
    float amount;
} Order;

Customer customers[MAX_CUSTOMERS];
Item items[MAX_ITEMS];
Order orders[MAX_ITEMS];

int num_customers = 0;
int num_items = 0;
int num_orders = 0;

void add_customer(Customer* c) {
    strcpy(customers[num_customers].name, c->name);
    customers[num_customers].id = num_customers;
    customers[num_customers].balance = 0;
    num_customers++;
}

void add_item(Item* i) {
    strcpy(items[num_items].name, i->name);
    items[num_items].id = num_items;
    items[num_items].price = i->price;
    num_items++;
}

void add_order(Order* o) {
    strcpy(orders[num_orders].name, o->name);
    orders[num_orders].id = num_orders;
    orders[num_orders].amount = o->amount;
    num_orders++;
}

void print_customers() {
    printf("Customers:\n");
    for (int i = 0; i < num_customers; i++) {
        printf("%d. %s - Balance: %.2f\n", customers[i].id, customers[i].name, customers[i].balance);
    }
}

void print_items() {
    printf("\nItems:\n");
    for (int i = 0; i < num_items; i++) {
        printf("%d. %s - Price: %.2f\n", items[i].id, items[i].name, items[i].price);
    }
}

void print_orders() {
    printf("\nOrders:\n");
    for (int i = 0; i < num_orders; i++) {
        printf("%d. %s - Amount: %.2f\n", orders[i].id, orders[i].name, orders[i].amount);
    }
}

int main() {
    // Add customers
    Customer c1 = {"John Doe", 0};
    Customer c2 = {"Jane Smith", 0};
    add_customer(&c1);
    add_customer(&c2);

    // Add items
    Item i1 = {"Coffee", 2.50};
    Item i2 = {"Donut", 1.00};
    add_item(&i1);
    add_item(&i2);

    // Place orders
    Order o1 = {"Coffee", 2.50};
    Order o2 = {"Donut", 1.00};
    add_order(&o1);
    add_order(&o2);

    // Print customers, items, and orders
    print_customers();
    print_items();
    print_orders();

    return 0;
}