//GEMINI-pro DATASET v1.0 Category: Weather simulation ; Style: dynamic
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

// Define the weather types
#define SUNNY 0
#define CLOUDY 1
#define RAINY 2
#define STORMY 3

// Define the temperature range
#define MIN_TEMP 0
#define MAX_TEMP 40

// Define the humidity range
#define MIN_HUMIDITY 0
#define MAX_HUMIDITY 100

// Define the wind speed range
#define MIN_WIND_SPEED 0
#define MAX_WIND_SPEED 100

// Define the number of days to simulate
#define NUM_DAYS 10

// Create a structure to store the weather data
typedef struct weather {
    int type;
    int temperature;
    int humidity;
    int wind_speed;
} weather;

// Create an array to store the weather data
weather weather_data[NUM_DAYS];

// Generate random weather data
void generate_weather_data() {
    for (int i = 0; i < NUM_DAYS; i++) {
        // Generate a random weather type
        weather_data[i].type = rand() % 4;

        // Generate a random temperature
        weather_data[i].temperature = rand() % (MAX_TEMP - MIN_TEMP + 1) + MIN_TEMP;

        // Generate a random humidity
        weather_data[i].humidity = rand() % (MAX_HUMIDITY - MIN_HUMIDITY + 1) + MIN_HUMIDITY;

        // Generate a random wind speed
        weather_data[i].wind_speed = rand() % (MAX_WIND_SPEED - MIN_WIND_SPEED + 1) + MIN_WIND_SPEED;
    }
}

// Print the weather data
void print_weather_data() {
    printf("Weather data for the next %d days:\n", NUM_DAYS);
    for (int i = 0; i < NUM_DAYS; i++) {
        printf("Day %d:\n", i + 1);
        switch (weather_data[i].type) {
            case SUNNY:
                printf("  Weather: Sunny\n");
                break;
            case CLOUDY:
                printf("  Weather: Cloudy\n");
                break;
            case RAINY:
                printf("  Weather: Rainy\n");
                break;
            case STORMY:
                printf("  Weather: Stormy\n");
                break;
        }
        printf("  Temperature: %d degrees Celsius\n", weather_data[i].temperature);
        printf("  Humidity: %d%%\n", weather_data[i].humidity);
        printf("  Wind speed: %d km/h\n", weather_data[i].wind_speed);
        printf("\n");
    }
}

// Main function
int main() {
    // Initialize the random number generator
    srand(time(NULL));

    // Generate the weather data
    generate_weather_data();

    // Print the weather data
    print_weather_data();

    return 0;
}