//Falcon-180B DATASET v1.0 Category: Network Topology Mapper ; Style: scientific
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#define MAX_NODES 100
#define MAX_EDGES 500
#define MAX_WEIGHT 100

typedef struct {
    int src;
    int dest;
    int weight;
} Edge;

typedef struct {
    int id;
    char name[20];
} Node;

Node nodes[MAX_NODES];
Edge edges[MAX_EDGES];

int num_nodes = 0;
int num_edges = 0;

void add_node(char* name) {
    strcpy(nodes[num_nodes].name, name);
    nodes[num_nodes].id = num_nodes;
    num_nodes++;
}

int find_node(char* name) {
    for(int i=0; i<num_nodes; i++) {
        if(!strcmp(nodes[i].name, name)) {
            return i;
        }
    }
    return -1;
}

void add_edge(int src, int dest, int weight) {
    edges[num_edges].src = src;
    edges[num_edges].dest = dest;
    edges[num_edges].weight = weight;
    num_edges++;
}

void print_nodes() {
    printf("Nodes:\n");
    for(int i=0; i<num_nodes; i++) {
        printf("%d: %s\n", i, nodes[i].name);
    }
}

void print_edges() {
    printf("\nEdges:\n");
    for(int i=0; i<num_edges; i++) {
        printf("%d -> %d (%d)\n", edges[i].src, edges[i].dest, edges[i].weight);
    }
}

void main() {
    add_node("Node 1");
    add_node("Node 2");
    add_node("Node 3");
    add_node("Node 4");

    add_edge(0, 1, 10);
    add_edge(1, 2, 20);
    add_edge(2, 3, 30);

    print_nodes();
    print_edges();
}