//Falcon-180B DATASET v1.0 Category: Stock market tracker ; Style: satisfied
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>

#define MAX_STOCKS 100
#define MAX_HISTORY 100

typedef struct {
    char name[20];
    float price;
    char symbol[5];
} Stock;

typedef struct {
    time_t timestamp;
    Stock stock;
} StockHistory;

Stock stocks[MAX_STOCKS];
StockHistory history[MAX_HISTORY];
int numStocks = 0;
int numHistory = 0;

void addStock(char* name, float price, char* symbol) {
    if (numStocks >= MAX_STOCKS) {
        printf("Error: Maximum number of stocks reached.\n");
        return;
    }
    strcpy(stocks[numStocks].name, name);
    stocks[numStocks].price = price;
    strcpy(stocks[numStocks].symbol, symbol);
    numStocks++;
}

void addStockHistory(Stock stock) {
    if (numHistory >= MAX_HISTORY) {
        printf("Error: Maximum number of stock history reached.\n");
        return;
    }
    history[numHistory].timestamp = time(NULL);
    history[numHistory].stock = stock;
    numHistory++;
}

void printStockHistory() {
    printf("Stock History:\n");
    for (int i = 0; i < numHistory; i++) {
        printf("%s: $%.2f (%s)\n", history[i].stock.name, history[i].stock.price, history[i].stock.symbol);
    }
}

int main() {
    addStock("Apple", 150.00, "AAPL");
    addStock("Google", 1000.00, "GOOG");
    addStock("Amazon", 2000.00, "AMZN");

    for (int i = 0; i < numStocks; i++) {
        printf("%s: $%.2f (%s)\n", stocks[i].name, stocks[i].price, stocks[i].symbol);
    }

    addStockHistory(stocks[0]);
    addStockHistory(stocks[1]);
    addStockHistory(stocks[2]);

    printStockHistory();

    return 0;
}