//Falcon-180B DATASET v1.0 Category: Modern Encryption ; Style: energetic
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

// Function to generate a random number
int rand_num() {
    return rand() % 256;
}

// Function to generate a random key
void generate_key(char key[], int key_size) {
    for (int i = 0; i < key_size; i++) {
        key[i] = rand_num();
    }
}

// Function to encrypt a message using the given key
void encrypt(char message[], char key[], int key_size, char encrypted_message[]) {
    int message_length = strlen(message);
    int key_index = 0;
    for (int i = 0; i < message_length; i++) {
        encrypted_message[i] = message[i] ^ key[key_index];
        key_index = (key_index + 1) % key_size;
    }
    encrypted_message[message_length] = '\0';
}

// Function to decrypt an encrypted message using the given key
void decrypt(char encrypted_message[], char key[], int key_size, char decrypted_message[]) {
    int message_length = strlen(encrypted_message);
    int key_index = 0;
    for (int i = 0; i < message_length; i++) {
        decrypted_message[i] = encrypted_message[i] ^ key[key_index];
        key_index = (key_index + 1) % key_size;
    }
    decrypted_message[message_length] = '\0';
}

// Function to print a message to the console
void print_message(char message[]) {
    printf("%s\n", message);
}

int main() {
    srand(time(NULL)); // Seed the random number generator with the current time

    // Set the message to encrypt
    char message[] = "Hello, world! ";

    // Set the key size (in bytes)
    int key_size = 16;

    // Generate a random key
    char key[key_size];
    generate_key(key, key_size);

    // Encrypt the message using the key
    char encrypted_message[strlen(message) + 1];
    encrypt(message, key, key_size, encrypted_message);

    // Print the encrypted message
    print_message("Encrypted message:");
    print_message(encrypted_message);

    // Decrypt the encrypted message using the key
    char decrypted_message[strlen(message) + 1];
    decrypt(encrypted_message, key, key_size, decrypted_message);

    // Print the decrypted message
    print_message("Decrypted message:");
    print_message(decrypted_message);

    return 0;
}