//GPT-4o-mini DATASET v1.0 Category: Building a SMTP Client ; Style: rigorous
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <arpa/inet.h>

#define SMTP_PORT 25
#define BUFFER_SIZE 1024

void send_command(int socket, const char *command) {
    send(socket, command, strlen(command), 0);
    char buffer[BUFFER_SIZE];
    recv(socket, buffer, sizeof(buffer) - 1, 0);
    buffer[BUFFER_SIZE - 1] = '\0'; // Null terminate buffer
    printf("%s", buffer);
}

int main(int argc, char *argv[]) {
    if (argc != 5) {
        fprintf(stderr, "Usage: %s <SMTP_SERVER> <FROM_EMAIL> <TO_EMAIL> <SUBJECT>\n", argv[0]);
        exit(EXIT_FAILURE);
    }

    const char *smtp_server = argv[1];
    const char *from_email = argv[2];
    const char *to_email = argv[3];
    const char *subject = argv[4];
    char buffer[BUFFER_SIZE];

    // Create socket
    int smtp_socket = socket(AF_INET, SOCK_STREAM, 0);
    if (smtp_socket < 0) {
        perror("Failed to create socket");
        return EXIT_FAILURE;
    }

    // Define server address
    struct sockaddr_in server_addr;
    server_addr.sin_family = AF_INET;
    server_addr.sin_port = htons(SMTP_PORT);
    inet_pton(AF_INET, smtp_server, &server_addr.sin_addr);

    // Connect to SMTP server
    if (connect(smtp_socket, (struct sockaddr*)&server_addr, sizeof(server_addr)) < 0) {
        perror("Connection to SMTP server failed");
        close(smtp_socket);
        return EXIT_FAILURE;
    }

    // Read server greeting
    read(smtp_socket, buffer, sizeof(buffer) - 1);
    buffer[BUFFER_SIZE - 1] = '\0';
    printf("Server: %s", buffer);

    // HELO command
    send_command(smtp_socket, "HELO localhost\r\n");

    // MAIL FROM command
    snprintf(buffer, sizeof(buffer), "MAIL FROM: <%s>\r\n", from_email);
    send_command(smtp_socket, buffer);

    // RCPT TO command
    snprintf(buffer, sizeof(buffer), "RCPT TO: <%s>\r\n", to_email);
    send_command(smtp_socket, buffer);

    // DATA command
    send_command(smtp_socket, "DATA\r\n");

    // Create email message
    snprintf(buffer, sizeof(buffer),
             "From: %s\r\n"
             "To: %s\r\n"
             "Subject: %s\r\n"
             "\r\n"
             "This is a test email sent via a simple SMTP client.\r\n"
             ".\r\n", from_email, to_email, subject);
    send(smtp_socket, buffer, strlen(buffer), 0);

    // Read server response for DATA
    read(smtp_socket, buffer, sizeof(buffer) - 1);
    buffer[BUFFER_SIZE - 1] = '\0';
    printf("Server: %s", buffer);

    // QUIT command
    send_command(smtp_socket, "QUIT\r\n");

    // Clean up and close socket
    close(smtp_socket);
    return EXIT_SUCCESS;
}