//Gemma-7B DATASET v1.0 Category: Space Invaders Game Clone ; Style: puzzling
#include <stdio.h>
#include <stdlib.h>

#define MAX_WIDTH 50
#define MAX_HEIGHT 20

#define PLAYER_WIDTH 5
#define PLAYER_HEIGHT 1

#define BULLET_WIDTH 1
#define BULLET_HEIGHT 1

#define ENEMY_WIDTH 2
#define ENEMY_HEIGHT 2

#define NUM_ENEMIES 10

typedef struct Enemy {
    int x;
    int y;
    int direction;
} Enemy;

Enemy enemies[NUM_ENEMIES];

void initializeEnemies() {
    for (int i = 0; i < NUM_ENEMIES; i++) {
        enemies[i].x = rand() % MAX_WIDTH;
        enemies[i].y = rand() % MAX_HEIGHT;
        enemies[i].direction = rand() % 2;
    }
}

void moveEnemies() {
    for (int i = 0; i < NUM_ENEMIES; i++) {
        switch (enemies[i].direction) {
            case 0:
                enemies[i].x++;
                break;
            case 1:
                enemies[i].x--;
                break;
            case 2:
                enemies[i].y++;
                break;
            case 3:
                enemies[i].y--;
                break;
        }

        if (enemies[i].x >= MAX_WIDTH - ENEMY_WIDTH || enemies[i].x <= 0) {
            enemies[i].direction ^= 1;
        }

        if (enemies[i].y >= MAX_HEIGHT - ENEMY_HEIGHT || enemies[i].y <= 0) {
            enemies[i].direction ^= 1;
        }
    }
}

int main() {
    initializeEnemies();
    moveEnemies();

    return 0;
}