//Falcon-180B DATASET v1.0 Category: Packet Capturer with pcap library ; Style: configurable
#include <stdio.h>
#include <pcap.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>

// Function to print the captured packet
void print_packet(u_char *args, const struct pcap_pkthdr *header, const u_char *packet) {
    printf("Captured Packet:\n");
    printf("-----------------\n");
    printf("Length: %d\n", header->len);
    printf("Data:\n");
    for (int i = 0; i < header->len; i++) {
        printf("%02X ", packet[i]);
    }
    printf("\n");
}

// Function to handle the captured packets
void handle_packet(u_char *args, const struct pcap_pkthdr *header, const u_char *packet) {
    print_packet(args, header, packet);
}

int main(int argc, char *argv[]) {
    char *dev;
    char errbuf[PCAP_ERRBUF_SIZE];
    pcap_t *handle;
    struct bpf_program fp;

    // Check if the correct number of arguments are provided
    if (argc!= 3) {
        printf("Usage: %s <interface> <filter>\n", argv[0]);
        exit(1);
    }

    // Open the network interface for capturing
    dev = argv[1];
    handle = pcap_open_live(dev, 65535, 1, 0, errbuf);
    if (handle == NULL) {
        printf("Error opening %s: %s\n", dev, errbuf);
        exit(1);
    }

    // Compile the filter expression
    if (pcap_compile(handle, &fp, argv[2], 1, 0) == -1) {
        printf("Error compiling filter: %s\n", pcap_geterr(handle));
        exit(1);
    }

    // Set the filter for the capture
    if (pcap_setfilter(handle, &fp) == -1) {
        printf("Error setting filter: %s\n", pcap_geterr(handle));
        exit(1);
    }

    // Loop to capture packets
    pcap_loop(handle, -1, handle_packet, NULL);

    // Close the capture handle
    pcap_freecode(&fp);
    pcap_close(handle);

    return 0;
}