//Code Llama-13B DATASET v1.0 Category: Movie Rating System ; Style: configurable
#include <stdio.h>
#include <stdlib.h>

#define MAX_RATINGS 5
#define MAX_MOVIES 10

// Structure to store movie details
struct Movie {
    char title[50];
    int rating;
};

// Structure to store user ratings
struct Rating {
    int movie_id;
    int rating;
};

// Function to display movie ratings
void display_ratings(struct Rating ratings[], int num_ratings) {
    for (int i = 0; i < num_ratings; i++) {
        printf("Movie: %s, Rating: %d\n", ratings[i].movie_id, ratings[i].rating);
    }
}

// Function to add a new movie rating
void add_rating(struct Rating *ratings, int *num_ratings, int movie_id, int rating) {
    if (*num_ratings >= MAX_RATINGS) {
        printf("Rating limit reached. Cannot add more ratings.\n");
        return;
    }
    ratings[*num_ratings].movie_id = movie_id;
    ratings[*num_ratings].rating = rating;
    *num_ratings += 1;
}

// Function to remove a movie rating
void remove_rating(struct Rating *ratings, int *num_ratings, int movie_id) {
    if (*num_ratings <= 0) {
        printf("No ratings to remove.\n");
        return;
    }
    int index = -1;
    for (int i = 0; i < *num_ratings; i++) {
        if (ratings[i].movie_id == movie_id) {
            index = i;
            break;
        }
    }
    if (index == -1) {
        printf("Movie not found.\n");
        return;
    }
    for (int i = index; i < *num_ratings - 1; i++) {
        ratings[i] = ratings[i + 1];
    }
    *num_ratings -= 1;
}

int main() {
    // Initialize movie database
    struct Movie movies[MAX_MOVIES];
    int num_movies = 0;
    // Initialize user ratings
    struct Rating ratings[MAX_RATINGS];
    int num_ratings = 0;

    // Add movie ratings
    add_rating(ratings, &num_ratings, 1, 4);
    add_rating(ratings, &num_ratings, 2, 3);
    add_rating(ratings, &num_ratings, 3, 5);

    // Display movie ratings
    display_ratings(ratings, num_ratings);

    // Remove a movie rating
    remove_rating(ratings, &num_ratings, 2);

    // Display movie ratings again
    display_ratings(ratings, num_ratings);

    return 0;
}