//Falcon-180B DATASET v1.0 Category: Sudoku solver ; Style: protected
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define SIZE 9

void print_matrix(int matrix[SIZE][SIZE]) {
    int i, j;
    for (i = 0; i < SIZE; i++) {
        for (j = 0; j < SIZE; j++) {
            printf("%d ", matrix[i][j]);
        }
        printf("\n");
    }
}

int is_valid(int matrix[SIZE][SIZE], int row, int col, int num) {
    int i, j;
    for (i = 0; i < SIZE; i++) {
        if (matrix[row][i] == num || matrix[i][col] == num) {
            return 0;
        }
    }
    for (i = 0; i < 3; i++) {
        for (j = 0; j < 3; j++) {
            if (matrix[(row / 3) * 3 + i][(col / 3) * 3 + j] == num) {
                return 0;
            }
        }
    }
    return 1;
}

void fill_matrix(int matrix[SIZE][SIZE]) {
    int i, j;
    for (i = 0; i < SIZE; i++) {
        for (j = 0; j < SIZE; j++) {
            matrix[i][j] = 0;
        }
    }
}

void generate_matrix(int matrix[SIZE][SIZE]) {
    int i, j;
    srand(time(NULL));
    for (i = 0; i < SIZE; i++) {
        for (j = 0; j < SIZE; j++) {
            matrix[i][j] = rand() % 9 + 1;
        }
    }
}

int main() {
    int matrix[SIZE][SIZE];
    int i, j;
    fill_matrix(matrix);
    generate_matrix(matrix);
    print_matrix(matrix);
    return 0;
}