//Gemma-7B DATASET v1.0 Category: Hotel Management System ; Style: multiplayer
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Define the number of rooms in the hotel
#define NUM_ROOMS 100

// Define the room structure
typedef struct Room {
    int number;
    char status;
    char guest_name[20];
    int num_guests;
} Room;

// Create an array of rooms
Room rooms[NUM_ROOMS];

// Function to check if a room is available
int is_room_available(int room_number) {
    return rooms[room_number].status == 'A';
}

// Function to book a room
void book_room(int room_number, char guest_name, int num_guests) {
    rooms[room_number].status = 'B';
    strcpy(rooms[room_number].guest_name, guest_name);
    rooms[room_number].num_guests = num_guests;
}

// Function to list all available rooms
void list_available_rooms() {
    for (int i = 0; i < NUM_ROOMS; i++) {
        if (rooms[i].status == 'A') {
            printf("Room %d is available.\n", rooms[i].number);
        }
    }
}

int main() {
    // Initialize the rooms
    for (int i = 0; i < NUM_ROOMS; i++) {
        rooms[i].number = i + 1;
        rooms[i].status = 'A';
        rooms[i].guest_name[0] = '\0';
        rooms[i].num_guests = 0;
    }

    // List all available rooms
    list_available_rooms();

    // Book a room
    book_room(10, "John Doe", 2);

    // List all available rooms after booking a room
    list_available_rooms();

    return 0;
}