//GPT-4o-mini DATASET v1.0 Category: Syntax parsing ; Style: Dennis Ritchie
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#define MAX_TOKEN_SIZE 100
#define MAX_TOKENS 200

typedef enum {
    TOKEN_NUMBER,
    TOKEN_IDENTIFIER,
    TOKEN_OPERATOR,
    TOKEN_SEMICOLON,
    TOKEN_UNKNOWN,
    TOKEN_END
} TokenType;

typedef struct {
    TokenType type;
    char value[MAX_TOKEN_SIZE];
} Token;

Token tokens[MAX_TOKENS];
int token_count = 0;

// Function to display the tokens
void print_tokens() {
    for (int i = 0; i < token_count; i++) {
        printf("Token %d: Type: %d, Value: '%s'\n", i + 1, tokens[i].type, tokens[i].value);
    }
}

// Function to get the next token from the input
Token get_next_token(const char **input) {
    Token token;
    while (isspace(**input)) (*input)++; // Skip whitespace

    if (**input == '\0') {
        token.type = TOKEN_END;
        strcpy(token.value, "EOF");
        return token;
    }

    if (isdigit(**input)) {
        token.type = TOKEN_NUMBER;
        int i = 0;
        while (isdigit(**input)) {
            token.value[i++] = **input;
            (*input)++;
        }
        token.value[i] = '\0';
    } else if (isalpha(**input) || **input == '_') {
        token.type = TOKEN_IDENTIFIER;
        int i = 0;
        while (isalnum(**input) || **input == '_') {
            token.value[i++] = **input;
            (*input)++;
        }
        token.value[i] = '\0';
    } else if (strchr("+-*/%=", **input) != NULL) {
        token.type = TOKEN_OPERATOR;
        token.value[0] = **input;
        token.value[1] = '\0';
        (*input)++;
    } else if (**input == ';') {
        token.type = TOKEN_SEMICOLON;
        token.value[0] = **input;
        token.value[1] = '\0';
        (*input)++;
    } else {
        token.type = TOKEN_UNKNOWN;
        token.value[0] = **input;
        token.value[1] = '\0';
        (*input)++;
    }

    return token;
}

// Function to tokenize input string
void tokenize(const char *input) {
    const char *ptr = input;
    Token token;

    while (1) {
        token = get_next_token(&ptr);
        tokens[token_count++] = token;

        if (token.type == TOKEN_END || token_count >= MAX_TOKENS) {
            break;
        }
    }
}

// Main function
int main() {
    const char *source_code = "int main() { int a = 10; float b = 5.5; a += b; return 0; }";
    
    printf("Source Code:\n%s\n", source_code);
    tokenize(source_code);
    printf("\nTokens:\n");
    print_tokens();
    
    return 0;
}