//Gemma-7B DATASET v1.0 Category: Elevator Simulation ; Style: dynamic
#include <stdio.h>
#include <stdlib.h>

// Define the number of floors in the elevator
#define NUM_FLOORS 5

// Define the elevator floor numbers
const int FLOOR_NUMS[] = {1, 2, 3, 4, 5};

// Define the elevator current floor number
int current_floor = 1;

// Define the elevator direction (up or down)
char direction = 'u';

// Define the elevator door status (open or closed)
int door_status = 0;

// Function to move the elevator to a specific floor
void move_elevator(int target_floor) {
  // Calculate the number of floors to move
  int num_floors = abs(current_floor - target_floor);

  // Move the elevator up or down
  if (direction == 'u') {
    for (int i = 0; i < num_floors; i++) {
      current_floor++;
      printf("Elevator moving up to floor %d\n", current_floor);
    }
  } else if (direction == 'd') {
    for (int i = 0; i < num_floors; i++) {
      current_floor--;
      printf("Elevator moving down to floor %d\n", current_floor);
    }
  }

  // Update the current floor number
  current_floor = target_floor;

  // Open the elevator door
  door_status = 1;
  printf("Elevator door opened on floor %d\n", current_floor);
}

// Main function
int main() {
  // Move the elevator to the third floor
  move_elevator(3);

  // Move the elevator to the second floor
  move_elevator(2);

  // Move the elevator to the fifth floor
  move_elevator(5);

  return 0;
}