//GEMINI-pro DATASET v1.0 Category: Haunted House Simulator ; Style: puzzling
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

// Define the haunted house map
#define MAP_WIDTH 10
#define MAP_HEIGHT 10

char map[MAP_WIDTH][MAP_HEIGHT] = {
    {'#', '#', '#', '#', '#', '#', '#', '#', '#', '#'},
    {'#', '.', '.', '.', '.', '.', '.', '.', '.', '#'},
    {'#', '.', '.', '.', '.', '.', '.', '.', '.', '#'},
    {'#', '.', '.', '.', '.', '.', '.', '.', '.', '#'},
    {'#', '.', '.', '.', '.', '.', '.', '.', '.', '#'},
    {'#', '.', '.', '.', '.', '.', '.', '.', '.', '#'},
    {'#', '.', '.', '.', '.', '.', '.', '.', '.', '#'},
    {'#', '.', '.', '.', '.', '.', '.', '.', '.', '#'},
    {'#', '.', '.', '.', '.', '.', '.', '.', '.', '#'},
    {'#', '#', '#', '#', '#', '#', '#', '#', '#', '#'}
};

// Define the player's position
int player_x = 1;
int player_y = 1;

// Define the ghost's position
int ghost_x = 8;
int ghost_y = 8;

// Define the game state
enum game_state {
    GAME_RUNNING,
    GAME_OVER,
    GAME_WON
};

// Define the game loop
void game_loop() {
    // Get the player's input
    char input = getchar();

    // Move the player based on the input
    switch (input) {
        case 'w':
            player_y--;
            break;
        case 'a':
            player_x--;
            break;
        case 's':
            player_y++;
            break;
        case 'd':
            player_x++;
            break;
    }

    // Check if the player has won
    if (player_x == ghost_x && player_y == ghost_y) {
        printf("You win!\n");
        exit(0);
    }

    // Check if the player has lost
    if (map[player_x][player_y] == '#') {
        printf("You lose!\n");
        exit(0);
    }

    // Move the ghost
    int dx = ghost_x - player_x;
    int dy = ghost_y - player_y;

    if (dx > 0) {
        ghost_x--;
    } else if (dx < 0) {
        ghost_x++;
    }

    if (dy > 0) {
        ghost_y--;
    } else if (dy < 0) {
        ghost_y++;
    }

    // Check if the player has lost
    if (player_x == ghost_x && player_y == ghost_y) {
        printf("You lose!\n");
        exit(0);
    }

    // Draw the map
    for (int y = 0; y < MAP_HEIGHT; y++) {
        for (int x = 0; x < MAP_WIDTH; x++) {
            if (x == player_x && y == player_y) {
                printf("P");
            } else if (x == ghost_x && y == ghost_y) {
                printf("G");
            } else {
                printf("%c", map[x][y]);
            }
        }
        printf("\n");
    }
}

int main() {
    // Seed the random number generator
    srand(time(NULL));

    // Place the ghost in a random location
    ghost_x = rand() % MAP_WIDTH;
    ghost_y = rand() % MAP_HEIGHT;

    // Start the game loop
    game_loop();

    return 0;
}