//GEMINI-pro DATASET v1.0 Category: TCP/IP Programming ; Style: thoughtful
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#define PORT 8080

int main() {
    int sockfd, newsockfd, valread;
    struct sockaddr_in servaddr, cliaddr;
    char buffer[1024] = {0};
    char *hello = "Hello from server";

    // Creating socket file descriptor
    if ((sockfd = socket(AF_INET, SOCK_STREAM, 0)) == 0) {
        perror("socket failed");
        exit(EXIT_FAILURE);
    } else {
        printf("Socket created successfully\n");
    }

    // Set socket options
    int opt = 1;
    if (setsockopt(sockfd, SOL_SOCKET, SO_REUSEADDR | SO_REUSEPORT, &opt, sizeof(opt))) {
        perror("setsockopt");
        exit(EXIT_FAILURE);
    } else {
        printf("Socket options set successfully\n");
    }

    // Assign IP address and port to the server
    servaddr.sin_family = AF_INET;
    servaddr.sin_addr.s_addr = INADDR_ANY;
    servaddr.sin_port = htons(PORT);

    // Bind the socket to the assigned IP and port
    if (bind(sockfd, (struct sockaddr *)&servaddr, sizeof(servaddr)) < 0) {
        perror("bind failed");
        exit(EXIT_FAILURE);
    } else {
        printf("Socket binded successfully\n");
    }

    // Listening for incoming connections
    if (listen(sockfd, 3) < 0) {
        perror("listen failed");
        exit(EXIT_FAILURE);
    } else {
        printf("Server is listening on port %d\n", PORT);
    }

    // Accept incoming connection
    int len = sizeof(cliaddr);
    if ((newsockfd = accept(sockfd, (struct sockaddr *)&cliaddr, &len)) < 0) {
        perror("accept failed");
        exit(EXIT_FAILURE);
    } else {
        printf("New connection accepted from %s:%d\n", inet_ntoa(cliaddr.sin_addr), ntohs(cliaddr.sin_port));
    }

    // Send response to the client
    send(newsockfd, hello, strlen(hello), 0);
    printf("Hello message sent to the client\n");

    // Receive data from the client
    valread = read(newsockfd, buffer, 1024);
    printf("Message received from the client: %s\n", buffer);

    // Close the connection
    close(newsockfd);
    close(sockfd);

    return 0;
}