//Falcon-180B DATASET v1.0 Category: Bucket Sort Implementation ; Style: introspective
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_SIZE 1000

// Function to swap two elements
void swap(int* a, int* b) {
    int temp = *a;
    *a = *b;
    *b = temp;
}

// Function to print an array
void printArray(int arr[], int size) {
    for (int i = 0; i < size; i++) {
        printf("%d ", arr[i]);
    }
    printf("\n");
}

// Function to perform bucket sort
void bucketSort(int arr[], int size) {
    // Create an array of empty buckets
    int buckets[MAX_SIZE] = {0};

    // Determine the range of the input array
    int min = arr[0];
    int max = arr[0];
    for (int i = 1; i < size; i++) {
        if (arr[i] < min) {
            min = arr[i];
        }
        if (arr[i] > max) {
            max = arr[i];
        }
    }

    // Determine the bucket size
    int bucketSize = (max - min + 1) / size;

    // Place each element in its corresponding bucket
    for (int i = 0; i < size; i++) {
        int index = (arr[i] - min) / bucketSize;
        buckets[index]++;
    }

    // Modify the input array to contain the sorted elements
    int index = 0;
    for (int i = 0; i < max - min + 1; i++) {
        for (int j = 0; j < buckets[i]; j++) {
            arr[index++] = min + i;
        }
    }
}

int main() {
    int arr[] = {3, 7, 2, 9, 1, 5};
    int size = sizeof(arr) / sizeof(arr[0]);

    printf("Unsorted array:\n");
    printArray(arr, size);

    bucketSort(arr, size);

    printf("Sorted array:\n");
    printArray(arr, size);

    return 0;
}