//GEMINI-pro DATASET v1.0 Category: Alien Invasion Probability Calculator ; Style: authentic
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

// Initialize the random number generator
void init_rand() {
    srand(time(NULL));
}

// Generate a random integer between 0 and max
int rand_int(int max) {
    return rand() % (max + 1);
}

// Calculate the probability of an alien invasion
double calc_invasion_prob(int num_stars, int num_planets, double avg_pop_density) {
    // Calculate the total number of planets in the galaxy
    int num_planets_total = num_stars * num_planets;

    // Calculate the probability of an alien civilization existing on a given planet
    double prob_alien_civilization = 0.01;

    // Calculate the probability of an alien invasion
    double invasion_prob = prob_alien_civilization * num_planets_total * avg_pop_density;

    return invasion_prob;
}

// Print the invasion probability
void print_invasion_prob(double invasion_prob) {
    printf("The probability of an alien invasion is: %.2f%%\n", invasion_prob * 100);
}

// Main function
int main() {
    // Initialize the random number generator
    init_rand();

    // Get the number of stars in the galaxy
    int num_stars = rand_int(1000000);

    // Get the number of planets per star
    int num_planets = rand_int(10);

    // Get the average population density of the planets
    double avg_pop_density = 0.001;

    // Calculate the invasion probability
    double invasion_prob = calc_invasion_prob(num_stars, num_planets, avg_pop_density);

    // Print the invasion probability
    print_invasion_prob(invasion_prob);

    return 0;
}