//Falcon-180B DATASET v1.0 Category: Fitness Tracker ; Style: introspective
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define MAX_FITNESS_ACTIVITIES 10

typedef struct {
    char name[50];
    int duration;
    int caloriesBurned;
    time_t startTime;
    time_t endTime;
} FitnessActivity;

void addFitnessActivity(FitnessActivity* fitnessActivities, int numActivities, char* name, int duration, int caloriesBurned, time_t startTime, time_t endTime) {
    if (numActivities >= MAX_FITNESS_ACTIVITIES) {
        printf("Error: Maximum number of fitness activities reached.\n");
        return;
    }

    strcpy(fitnessActivities[numActivities].name, name);
    fitnessActivities[numActivities].duration = duration;
    fitnessActivities[numActivities].caloriesBurned = caloriesBurned;
    fitnessActivities[numActivities].startTime = startTime;
    fitnessActivities[numActivities].endTime = endTime;

    numActivities++;
}

void displayFitnessActivities(FitnessActivity* fitnessActivities, int numActivities) {
    printf("Fitness Activities:\n");
    printf("--------------------\n");

    for (int i = 0; i < numActivities; i++) {
        printf("Name: %s\n", fitnessActivities[i].name);
        printf("Duration: %d seconds\n", fitnessActivities[i].duration);
        printf("Calories Burned: %d\n", fitnessActivities[i].caloriesBurned);
        printf("Start Time: %s\n", ctime(&fitnessActivities[i].startTime));
        printf("End Time: %s\n", ctime(&fitnessActivities[i].endTime));
        printf("\n");
    }
}

int main() {
    FitnessActivity fitnessActivities[MAX_FITNESS_ACTIVITIES];
    int numActivities = 0;

    addFitnessActivity(fitnessActivities, numActivities, "Running", 30, 200, time(NULL), time(NULL));
    addFitnessActivity(fitnessActivities, numActivities, "Swimming", 45, 300, time(NULL), time(NULL));
    addFitnessActivity(fitnessActivities, numActivities, "Cycling", 60, 400, time(NULL), time(NULL));

    displayFitnessActivities(fitnessActivities, numActivities);

    return 0;
}