//Falcon-180B DATASET v1.0 Category: Recursive ; Style: detailed
#include <stdio.h>
#include <stdlib.h>

// Function to print an array in reverse order
void printArrayReverse(int arr[], int size) {
    if (size <= 0) {
        return;
    }

    printf("Array in reverse order: ");
    for (int i = size - 1; i >= 0; i--) {
        printf("%d ", arr[i]);
    }
    printf("\n");
}

// Function to calculate the factorial of a number using recursion
long long factorial(int n) {
    if (n == 0 || n == 1) {
        return 1;
    }

    return n * factorial(n - 1);
}

// Function to find the sum of all even numbers in an array using recursion
int sumEven(int arr[], int size, int sum) {
    if (size <= 0) {
        return sum;
    }

    if (arr[size - 1] % 2 == 0) {
        sum += arr[size - 1];
    }

    return sumEven(arr, size - 1, sum);
}

int main() {
    int arr[10] = {1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
    int size = sizeof(arr) / sizeof(arr[0]);

    // Print the array in reverse order using recursion
    printArrayReverse(arr, size);

    // Calculate the factorial of 5 using recursion
    long long result = factorial(5);
    printf("Factorial of 5 is: %lld\n", result);

    // Find the sum of all even numbers in the array using recursion
    int sum = 0;
    sum = sumEven(arr, size, sum);
    printf("Sum of even numbers in the array: %d\n", sum);

    return 0;
}