//Gemma-7B DATASET v1.0 Category: Traffic Flow Simulation ; Style: complete
#include <stdio.h>
#include <stdlib.h>

#define MAX_CARS 10

typedef struct Car {
  int position;
  int direction;
  int speed;
} Car;

Car cars[MAX_CARS];

void initializeCars() {
  for (int i = 0; i < MAX_CARS; i++) {
    cars[i].position = i;
    cars[i].direction = rand() % 2;
    cars[i].speed = rand() % 5 + 1;
  }
}

void moveCars() {
  for (int i = 0; i < MAX_CARS; i++) {
    switch (cars[i].direction) {
      case 0:
        cars[i].position++;
        break;
      case 1:
        cars[i].position--;
        break;
    }

    if (cars[i].position >= MAX_CARS - 1) {
      cars[i].direction = 1;
    } else if (cars[i].position <= 0) {
      cars[i].direction = 0;
    }
  }
}

void displayCars() {
  for (int i = 0; i < MAX_CARS; i++) {
    printf("Car %d: position %d, direction %d, speed %d\n", i, cars[i].position, cars[i].direction, cars[i].speed);
  }
}

int main() {
  initializeCars();
  moveCars();
  displayCars();

  return 0;
}