//Falcon-180B DATASET v1.0 Category: Greedy Algorithms ; Style: active
#include <stdio.h>
#include <stdlib.h>

// Function to find the activity selection problem
int activitySelection(int finishTime[], int startTime[], int n) {
    int i, j, max = 0, result = 0;

    for (i = 0; i < n; i++) {
        max = 0;
        for (j = 0; j < n; j++) {
            if (finishTime[j] > startTime[i] && finishTime[j] - startTime[i] > max)
                max = finishTime[j] - startTime[i];
        }
        if (max > result)
            result = max;
    }
    return result;
}

// Function to find the fractional knapsack problem
int fractionalKnapsack(int value[], int weight[], int W, int n) {
    int i, j, result = 0;

    for (i = 0; i < n; i++) {
        for (j = W; j >= weight[i]; j--) {
            result += ((j - weight[i]) / (double)weight[i]) * value[i];
        }
    }
    return result;
}

int main() {
    int i, n, result;

    // Activity selection problem
    int finishTime[] = { 2, 4, 6, 8 };
    int startTime[] = { 1, 2, 3, 5 };
    n = sizeof(finishTime) / sizeof(finishTime[0]);
    result = activitySelection(finishTime, startTime, n);
    printf("Activity selection problem: %d\n", result);

    // Fractional knapsack problem
    int value[] = { 60, 100, 120 };
    int weight[] = { 10, 20, 30 };
    int W = 50;
    n = sizeof(value) / sizeof(value[0]);
    result = fractionalKnapsack(value, weight, W, n);
    printf("Fractional knapsack problem: %d\n", result);

    return 0;
}