//GPT-4o-mini DATASET v1.0 Category: Network Ping Test ; Style: multiplayer
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <pthread.h>
#include <time.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <netinet/in.h>

#define MAX_PLAYERS 5
#define PING_COUNT 4
#define BUFFER_SIZE 64

typedef struct {
    int player_id;
    const char *server_ip;
} Player;

void *ping_server(void *arg) {
    Player *player = (Player *)arg;
    struct sockaddr_in server_addr;
    char buffer[BUFFER_SIZE];
    int sock;
    struct timespec start, end;
    long elapsed;
    
    // Create socket
    if ((sock = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP)) < 0) {
        perror("Socket creation failed");
        pthread_exit(NULL);
    }

    memset(&server_addr, 0, sizeof(server_addr));
    server_addr.sin_family = AF_INET;
    server_addr.sin_port = htons(8080); // change port if needed

    // Convert IP to binary form
    if (inet_pton(AF_INET, player->server_ip, &server_addr.sin_addr) <= 0) {
        perror("Invalid address/ Address not supported");
        close(sock);
        pthread_exit(NULL);
    }

    // Ping count loop
    for (int i = 0; i < PING_COUNT; i++) {
        clock_gettime(CLOCK_MONOTONIC, &start);
        
        // Send ping
        sprintf(buffer, "Ping from Player %d", player->player_id);
        if (sendto(sock, buffer, strlen(buffer), 0, (struct sockaddr *)&server_addr, sizeof(server_addr)) < 0) {
            perror("Ping send failed");
            break;
        }

        // Wait for a response
        socklen_t addr_len = sizeof(server_addr);
        if (recvfrom(sock, buffer, BUFFER_SIZE, 0, (struct sockaddr *)&server_addr, &addr_len) < 0) {
            perror("Ping response failed");
            break;
        }
        
        clock_gettime(CLOCK_MONOTONIC, &end);
        elapsed = (end.tv_sec - start.tv_sec) * 1e9 + (end.tv_nsec - start.tv_nsec);
        printf("Player %d: Received response in %ld nanoseconds\n", player->player_id, elapsed);
        
        sleep(1); // Wait for a second
    }

    close(sock);
    pthread_exit(NULL);
}

int main(int argc, char *argv[]) {
    if (argc != 2) {
        printf("Usage: %s <server_ip>\n", argv[0]);
        return 1;
    }

    pthread_t players[MAX_PLAYERS];
    Player player_info[MAX_PLAYERS];
    
    printf("Starting multiplayer ping test to %s...\n", argv[1]);

    // Create player threads
    for (int i = 0; i < MAX_PLAYERS; i++) {
        player_info[i].player_id = i + 1;
        player_info[i].server_ip = argv[1];
        if (pthread_create(&players[i], NULL, ping_server, &player_info[i]) != 0) {
            perror("Failed to create thread");
            return 1;
        }
    }

    // Wait for all player threads to finish
    for (int i = 0; i < MAX_PLAYERS; i++) {
        pthread_join(players[i], NULL);
    }

    printf("All players have finished pinging.\n");
    return 0;
}