//MISTRAL-7B DATASET v1.0 Category: Cafe Billing System ; Style: grateful
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_ORDER_SIZE 10
#define MAX_ITEM_NAME_LENGTH 50
#define MAX_ITEM_QUANTITY 10

typedef struct {
    char name[MAX_ITEM_NAME_LENGTH];
    int quantity;
    float price;
} Item;

typedef struct {
    Item items[MAX_ORDER_SIZE];
    int num_items;
    float total_cost;
} Order;

void add_item(Order *order, const char *name, int quantity, float price);
void display_order(const Order *order);

int main() {
    Order my_order = {0};

    add_item(&my_order, "Cappuccino", 2, 3.5);
    add_item(&my_order, "Mocha", 1, 4.0);
    add_item(&my_order, "Latte", 3, 3.0);

    printf("Order Details:\n");
    display_order(&my_order);
    printf("Total Cost: %.2f\n", my_order.total_cost);

    return 0;
}

void add_item(Order *order, const char *name, int quantity, float price) {
    // Check if there's enough space in the order to add the new item
    if (order->num_items + 1 >= MAX_ORDER_SIZE) {
        printf("Error: Order size exceeded.\n");
        return;
    }

    strcpy(order->items[order->num_items].name, name);
    order->items[order->num_items].quantity = quantity;
    order->items[order->num_items].price = price;

    order->total_cost += order->items[order->num_items].price * order->items[order->num_items].quantity;
    order->num_items++;
}

void display_order(const Order *order) {
    int i;

    for (i = 0; i < order->num_items; i++) {
        printf("%d. %s: %d x %.2f = %.2f\n", i + 1, order->items[i].name, order->items[i].quantity, order->items[i].price, order->items[i].price * order->items[i].quantity);
    }
}