//Falcon-180B DATASET v1.0 Category: Database querying ; Style: complete
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sqlite3.h>

#define DATABASE "example.db"
#define TABLE_NAME "users"
#define CREATE_TABLE_SQL \
    "CREATE TABLE IF NOT EXISTS " TABLE_NAME " (\
        id INTEGER PRIMARY KEY AUTOINCREMENT,\
        name TEXT NOT NULL,\
        age INTEGER NOT NULL\
    );"

static int callback(void *data, int argc, char **argv, char **azColName) {
    for (int i = 0; i < argc; i++) {
        printf("%s = %s\n", azColName[i], argv[i]? argv[i] : "NULL");
    }
    printf("\n");
    return 0;
}

void execute_sql(sqlite3 *db, const char *sql) {
    char *zErrMsg = 0;
    int rc = sqlite3_exec(db, sql, callback, 0, &zErrMsg);

    if (rc!= SQLITE_OK) {
        fprintf(stderr, "SQL error: %s\n", zErrMsg);
        sqlite3_free(zErrMsg);
    }
}

int main() {
    sqlite3 *db;
    int rc;

    rc = sqlite3_open(DATABASE, &db);

    if (rc) {
        fprintf(stderr, "Can't open database: %s\n", sqlite3_errmsg(db));
        return 1;
    }

    char *errMsg = 0;
    rc = sqlite3_exec(db, CREATE_TABLE_SQL, callback, 0, &errMsg);

    if (rc!= SQLITE_OK) {
        fprintf(stderr, "SQL error: %s\n", errMsg);
        sqlite3_free(errMsg);
    }

    const char *sql = "INSERT INTO " TABLE_NAME " (name, age) VALUES ('John', 30);";
    execute_sql(db, sql);

    sql = "INSERT INTO " TABLE_NAME " (name, age) VALUES ('Jane', 28);";
    execute_sql(db, sql);

    sql = "SELECT * FROM " TABLE_NAME;
    execute_sql(db, sql);

    sqlite3_close(db);
    return 0;
}