//Gemma-7B DATASET v1.0 Category: GPS Navigation Simulation ; Style: detailed
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <math.h>

#define PI 3.1415926535

// Define the GPS navigation structure
typedef struct GPS_NAV {
    double lat;
    double lng;
    double speed;
    double direction;
    time_t timestamp;
} GPS_NAV;

// Function to simulate GPS navigation
GPS_NAV simulate_gps_nav() {
    // Create a GPS navigation structure
    GPS_NAV nav;

    // Initialize the navigation structure
    nav.lat = 37.733333;
    nav.lng = -122.416666;
    nav.speed = 20;
    nav.direction = 45;
    nav.timestamp = time(NULL);

    // Simulate GPS signal noise
    double noise = rand() % 10;
    nav.lat += noise / 1000000;
    nav.lng += noise / 1000000;

    // Return the navigation structure
    return nav;
}

int main() {
    // Simulate GPS navigation
    GPS_NAV nav = simulate_gps_nav();

    // Print the navigation information
    printf("Lat: %.6f\n", nav.lat);
    printf("Lng: %.6f\n", nav.lng);
    printf("Speed: %.2f km/h\n", nav.speed);
    printf("Direction: %.2f degrees\n", nav.direction);
    printf("Timestamp: %ld\n", nav.timestamp);

    return 0;
}