//GEMINI-pro DATASET v1.0 Category: Log analysis ; Style: dynamic
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#define LOG_FILE "log.txt"

// Log levels
#define LOG_LEVEL_DEBUG 0
#define LOG_LEVEL_INFO 1
#define LOG_LEVEL_WARN 2
#define LOG_LEVEL_ERROR 3
#define LOG_LEVEL_FATAL 4

// Log colors
#define LOG_COLOR_DEFAULT "\x1B[0m"
#define LOG_COLOR_DEBUG "\x1B[36m"
#define LOG_COLOR_INFO "\x1B[32m"
#define LOG_COLOR_WARN "\x1B[33m"
#define LOG_COLOR_ERROR "\x1B[31m"
#define LOG_COLOR_FATAL "\x1B[35m"

// Log timestamps
#define LOG_TIMESTAMP_FORMAT "%Y-%m-%d %H:%M:%S"

// Log message format
#define LOG_MESSAGE_FORMAT "%s%s [%s] %s%s\n"

// Log function
void log(int level, const char *message) {
  // Get the current time
  time_t t = time(NULL);
  struct tm *tm = localtime(&t);

  // Format the timestamp
  char timestamp[256];
  strftime(timestamp, sizeof(timestamp), LOG_TIMESTAMP_FORMAT, tm);

  // Format the message
  const char *color;
  switch (level) {
    case LOG_LEVEL_DEBUG:
      color = LOG_COLOR_DEBUG;
      break;
    case LOG_LEVEL_INFO:
      color = LOG_COLOR_INFO;
      break;
    case LOG_LEVEL_WARN:
      color = LOG_COLOR_WARN;
      break;
    case LOG_LEVEL_ERROR:
      color = LOG_COLOR_ERROR;
      break;
    case LOG_LEVEL_FATAL:
      color = LOG_COLOR_FATAL;
      break;
    default:
      color = LOG_COLOR_DEFAULT;
      break;
  }

  char message_formatted[1024];
  snprintf(message_formatted, sizeof(message_formatted), LOG_MESSAGE_FORMAT, color, timestamp, level, message, LOG_COLOR_DEFAULT);

  // Write the message to the log file
  FILE *f = fopen(LOG_FILE, "a");
  if (f != NULL) {
    fprintf(f, "%s", message_formatted);
    fclose(f);
  }

  // Print the message to the console
  printf("%s", message_formatted);
}

// Main function
int main() {
  // Log a debug message
  log(LOG_LEVEL_DEBUG, "This is a debug message.");

  // Log an info message
  log(LOG_LEVEL_INFO, "This is an info message.");

  // Log a warning message
  log(LOG_LEVEL_WARN, "This is a warning message.");

  // Log an error message
  log(LOG_LEVEL_ERROR, "This is an error message.");

  // Log a fatal message
  log(LOG_LEVEL_FATAL, "This is a fatal message.");

  return 0;
}