//GEMINI-pro DATASET v1.0 Category: Digital Diary ; Style: safe
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#define MAX_ENTRIES 100
#define MAX_ENTRY_LENGTH 1024

// Structure to represent a diary entry
typedef struct {
  time_t timestamp;
  char entry[MAX_ENTRY_LENGTH];
} DiaryEntry;

// Function to add a new entry to the diary
void add_entry(DiaryEntry *diary, int *num_entries, const char *entry) {
  // Check if the diary is full
  if (*num_entries >= MAX_ENTRIES) {
    printf("Diary is full. Cannot add new entry.\n");
    return;
  }

  // Copy the entry into the diary
  strcpy(diary[*num_entries].entry, entry);

  // Set the timestamp
  diary[*num_entries].timestamp = time(NULL);

  // Increment the number of entries
  (*num_entries)++;
}

// Function to print the diary entries
void print_entries(const DiaryEntry *diary, int num_entries) {
  // Loop through the entries and print them
  for (int i = 0; i < num_entries; i++) {
    // Convert the timestamp to a readable format
    char *timestamp = ctime(&diary[i].timestamp);

    // Print the entry
    printf("%s\n%s\n", timestamp, diary[i].entry);
  }
}

// Function to clear the diary entries
void clear_entries(DiaryEntry *diary, int *num_entries) {
  // Set the number of entries to 0
  *num_entries = 0;
}

// Main function
int main() {
  // Declare a diary array
  DiaryEntry diary[MAX_ENTRIES];

  // Initialize the number of entries to 0
  int num_entries = 0;

  // Add beberapa entries to the diary
  add_entry(diary, &num_entries, "Dear Diary,\nI had a great day today. I went to the park with my friends and we played soccer.\n");
  add_entry(diary, &num_entries, "Dear Diary,\nI'm feeling a little down today. I had a fight with my best friend.\n");
  add_entry(diary, &num_entries, "Dear Diary,\nI'm so excited! I'm going on a trip to Paris next week.\n");

  // Print the diary entries
  print_entries(diary, num_entries);

  // Clear the diary entries
  clear_entries(diary, &num_entries);

  return 0;
}