//Falcon2-11B DATASET v1.0 Category: Building a SMTP Client ; Style: scalable
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#define PORT 25

int main() {
    int socket_fd, portno;
    struct sockaddr_in server_addr;

    socket_fd = socket(AF_INET, SOCK_STREAM, 0);

    if (socket_fd == -1) {
        perror("socket creation failed");
        exit(EXIT_FAILURE);
    }

    portno = htons(PORT);

    bzero((char *) &server_addr, sizeof(server_addr));

    server_addr.sin_family = AF_INET;
    server_addr.sin_port = htons(PORT);

    if (inet_pton(AF_INET, "127.0.0.1", &server_addr.sin_addr) <= 0) {
        perror("inet_pton failed");
        exit(EXIT_FAILURE);
    }

    if (connect(socket_fd, (struct sockaddr *) &server_addr, sizeof(server_addr)) < 0) {
        perror("connect failed");
        exit(EXIT_FAILURE);
    }

    printf("Connected to the SMTP server\n");

    char buffer[256];
    bzero(buffer, 256);

    if (send(socket_fd, "HELO localhost\r\n", 14, 0) < 0) {
        perror("send failed");
        exit(EXIT_FAILURE);
    }

    if (send(socket_fd, "MAIL FROM:<noreply@localhost>\r\n", 33, 0) < 0) {
        perror("send failed");
        exit(EXIT_FAILURE);
    }

    if (send(socket_fd, "RCPT TO:<someone@example.com>\r\n", 25, 0) < 0) {
        perror("send failed");
        exit(EXIT_FAILURE);
    }

    if (send(socket_fd, "DATA\r\n", 7, 0) < 0) {
        perror("send failed");
        exit(EXIT_FAILURE);
    }

    if (send(socket_fd, "Subject: This is a test email\r\n", 36, 0) < 0) {
        perror("send failed");
        exit(EXIT_FAILURE);
    }

    if (send(socket_fd, "From: noreply@localhost\r\n", 25, 0) < 0) {
        perror("send failed");
        exit(EXIT_FAILURE);
    }

    if (send(socket_fd, "To: someone@example.com\r\n", 25, 0) < 0) {
        perror("send failed");
        exit(EXIT_FAILURE);
    }

    if (send(socket_fd, "This is the body of the email.\r\n.", 40, 0) < 0) {
        perror("send failed");
        exit(EXIT_FAILURE);
    }

    if (send(socket_fd, ".\r\n", 4, 0) < 0) {
        perror("send failed");
        exit(EXIT_FAILURE);
    }

    if (send(socket_fd, "QUIT\r\n", 8, 0) < 0) {
        perror("send failed");
        exit(EXIT_FAILURE);
    }

    if (send(socket_fd, "Closing the connection to the SMTP server\n", 49, 0) < 0) {
        perror("send failed");
        exit(EXIT_FAILURE);
    }

    close(socket_fd);

    printf("Connection closed\n");

    return 0;
}