//GEMINI-pro DATASET v1.0 Category: Graph Coloring Problem ; Style: automated
#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>

// Number of vertices in the graph
#define V 4

// Function to check if the given color can be assigned to the given vertex
bool isSafe(int graph[V][V], int color[], int v, int c)
{
    for (int i = 0; i < V; i++)
    {
        if (graph[v][i] && color[i] == c)
            return false;
    }
    return true;
}

// A recursive utility function to solve the m coloring problem
bool graphColoring(int graph[V][V], int m, int color[], int v)
{
    // Base case: If all vertices are assigned a color then return true
    if (v == V)
        return true;

    // Consider all possible colors
    for (int c = 1; c <= m; c++)
    {
        // Check if the given color can be assigned to the v-th vertex
        if (isSafe(graph, color, v, c))
        {
            color[v] = c;

            // Recursively assign colors to the remaining vertices
            if (graphColoring(graph, m, color, v + 1))
                return true;

            // If assigning the given color to the v-th vertex doesn't lead to a solution then remove the color from the v-th vertex
            color[v] = 0;
        }
    }

    // If no color can be assigned to the v-th vertex then return false
    return false;
}

// Function to print the solution
void printSolution(int color[])
{
    printf("The following colors are assigned to the vertices:\n");
    for (int i = 0; i < V; i++)
        printf("Vertex %d -> Color %d\n", i, color[i]);
}

// Main function
int main()
{
    // Create a graph given in the above diagram
    int graph[V][V] = {
        {0, 1, 1, 1},
        {1, 0, 1, 0},
        {1, 1, 0, 1},
        {1, 0, 1, 0},
    };

    // Number of colors
    int m = 3;

    // Initialize all colors as 0
    int color[V] = {0};

    // Check if the graph can be colored with m colors
    if (graphColoring(graph, m, color, 0))
        printSolution(color);
    else
        printf("The graph cannot be colored with %d colors\n", m);

    return 0;
}