//Gemma-7B DATASET v1.0 Category: Tic Tac Toe AI ; Style: cheerful
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define BOARD_SIZE 3
#define PLAYER_X 1
#define PLAYER_O 2

#define MOVE_LEFT 0
#define MOVE_RIGHT 1
#define MOVE_UP 2
#define MOVE_DOWN 3

int main() {
    int board[BOARD_SIZE][BOARD_SIZE] = { { 0, 0, 0 }, { 0, 0, 0 }, { 0, 0, 0 } };
    int player = PLAYER_X;
    int move = 0;

    // Seed the random number generator
    srand(time(NULL));

    // Play until someone wins or it's a draw
    while (!board[move / BOARD_SIZE][move % BOARD_SIZE] && move < BOARD_SIZE * BOARD_SIZE) {
        // Get the move
        move = rand() % 9;

        // Make the move
        board[move / BOARD_SIZE][move % BOARD_SIZE] = player;

        // Switch players
        player = (player == PLAYER_X) ? PLAYER_O : PLAYER_X;
    }

    // Print the board
    for (int r = 0; r < BOARD_SIZE; r++) {
        for (int c = 0; c < BOARD_SIZE; c++) {
            printf("%d ", board[r][c]);
        }
        printf("\n");
    }

    // Print the winner or draw
    if (board[move / BOARD_SIZE][move % BOARD_SIZE] == PLAYER_X) {
        printf("Player X wins!\n");
    } else if (board[move / BOARD_SIZE][move % BOARD_SIZE] == PLAYER_O) {
        printf("Player O wins!\n");
    } else {
        printf("It's a draw!\n");
    }

    return 0;
}