//Code Llama-13B DATASET v1.0 Category: Networking ; Style: Claude Shannon
// Claude Shannon's Networking Example Program

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <unistd.h>

int main() {
    // Create a socket
    int sock = socket(AF_INET, SOCK_STREAM, 0);
    if (sock == -1) {
        perror("socket");
        exit(1);
    }

    // Set the socket options
    int option = 1;
    if (setsockopt(sock, SOL_SOCKET, SO_REUSEADDR, &option, sizeof(option)) < 0) {
        perror("setsockopt");
        exit(1);
    }

    // Bind the socket to a port
    struct sockaddr_in address;
    address.sin_family = AF_INET;
    address.sin_addr.s_addr = INADDR_ANY;
    address.sin_port = htons(8080);
    if (bind(sock, (struct sockaddr *)&address, sizeof(address)) < 0) {
        perror("bind");
        exit(1);
    }

    // Listen for incoming connections
    if (listen(sock, 3) < 0) {
        perror("listen");
        exit(1);
    }

    // Accept an incoming connection
    struct sockaddr_in client_address;
    socklen_t client_len = sizeof(client_address);
    int client_sock = accept(sock, (struct sockaddr *)&client_address, &client_len);
    if (client_sock < 0) {
        perror("accept");
        exit(1);
    }

    // Send a message to the client
    char *message = "Hello, client!";
    if (send(client_sock, message, strlen(message), 0) < 0) {
        perror("send");
        exit(1);
    }

    // Receive a message from the client
    char buffer[1024];
    int bytes_received = recv(client_sock, buffer, sizeof(buffer), 0);
    if (bytes_received < 0) {
        perror("recv");
        exit(1);
    }
    printf("Received message from client: %s\n", buffer);

    // Close the socket
    close(sock);

    return 0;
}