//Falcon-180B DATASET v1.0 Category: System event logger ; Style: inquisitive
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define EVENT_LOG_FILE "event_log.txt"
#define MAX_EVENT_LOG_SIZE 1000 // maximum number of events to log

typedef struct {
    time_t timestamp;
    char event_type[32];
    char event_message[256];
} Event;

FILE *event_log_file;
int event_count = 0;

void init_event_log() {
    event_log_file = fopen(EVENT_LOG_FILE, "w");
    if (event_log_file == NULL) {
        printf("Error: could not create event log file.\n");
        exit(1);
    }
}

void log_event(const char *event_type, const char *event_message) {
    if (event_count >= MAX_EVENT_LOG_SIZE) {
        printf("Error: event log is full.\n");
        return;
    }

    Event event;
    strcpy(event.event_type, event_type);
    strcpy(event.event_message, event_message);
    event.timestamp = time(NULL);

    fprintf(event_log_file, "%s: %s\n", ctime(&event.timestamp), event.event_message);
    event_count++;
}

void close_event_log() {
    fclose(event_log_file);
}

int main() {
    init_event_log();

    log_event("INFO", "Program started");

    // your program code here...

    log_event("INFO", "Program finished");

    close_event_log();

    return 0;
}