//Falcon-180B DATASET v1.0 Category: Cafe Billing System ; Style: interoperable
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_ITEMS 100
#define MAX_NAME 50
#define MAX_PRICE 10

// Define the structure of the item
typedef struct {
    char name[MAX_NAME];
    float price;
} Item;

// Define the structure of the order
typedef struct {
    int num_items;
    Item items[MAX_ITEMS];
    float total_price;
} Order;

// Function to add an item to the order
void add_item(Order *order) {
    int i;
    for (i = 0; i < order->num_items; i++) {
        if (strcmp(order->items[i].name, "") == 0) {
            printf("Enter the name of the item: ");
            scanf("%s", order->items[i].name);
            printf("Enter the price of the item: ");
            scanf("%f", &order->items[i].price);
            order->num_items++;
            break;
        }
    }
}

// Function to print the order
void print_order(Order *order) {
    int i;
    printf("Order:\n");
    printf("--------------------\n");
    for (i = 0; i < order->num_items; i++) {
        printf("%s - $%.2f\n", order->items[i].name, order->items[i].price);
    }
    printf("Total price: $%.2f\n", order->total_price);
    printf("--------------------\n");
}

// Function to calculate the total price of the order
void calculate_total_price(Order *order) {
    int i;
    order->total_price = 0;
    for (i = 0; i < order->num_items; i++) {
        order->total_price += order->items[i].price;
    }
}

// Main function
int main() {
    Order order;
    order.num_items = 0;

    // Add items to the order
    add_item(&order);
    add_item(&order);

    // Print the order
    print_order(&order);

    // Calculate the total price
    calculate_total_price(&order);

    // Print the order again
    print_order(&order);

    return 0;
}