//GEMINI-pro DATASET v1.0 Category: Public-Key Algorithm Implementation ; Style: synchronous
#include <openssl/pem.h>
#include <openssl/rsa.h>
#include <openssl/err.h>
#include <stdio.h>
#include <stdlib.h>

int main(int argc, char **argv)
{
    // Check arguments
    if (argc != 3) {
        fprintf(stderr, "Usage: %s <private key file> <public key file>\n", argv[0]);
        return EXIT_FAILURE;
    }

    // Load private key
    FILE *fp = fopen(argv[1], "r");
    if (fp == NULL) {
        fprintf(stderr, "Error opening private key file\n");
        return EXIT_FAILURE;
    }
    RSA *rsa = PEM_read_RSAPrivateKey(fp, NULL, NULL, NULL);
    fclose(fp);
    if (rsa == NULL) {
        fprintf(stderr, "Error loading private key\n");
        ERR_print_errors_fp(stderr);
        return EXIT_FAILURE;
    }

    // Load public key
    fp = fopen(argv[2], "r");
    if (fp == NULL) {
        fprintf(stderr, "Error opening public key file\n");
        return EXIT_FAILURE;
    }
    RSA *rsa_pub = PEM_read_RSA_PUBKEY(fp, NULL, NULL, NULL);
    fclose(fp);
    if (rsa_pub == NULL) {
        fprintf(stderr, "Error loading public key\n");
        ERR_print_errors_fp(stderr);
        return EXIT_FAILURE;
    }

    // Create message
    unsigned char message[] = "Hello, world!";
    int message_length = strlen(message);

    // Encrypt message
    unsigned char ciphertext[RSA_size(rsa)];
    int ciphertext_length = RSA_public_encrypt(message_length, message, ciphertext, rsa_pub, RSA_PKCS1_OAEP_PADDING);
    if (ciphertext_length == -1) {
        fprintf(stderr, "Error encrypting message\n");
        ERR_print_errors_fp(stderr);
        return EXIT_FAILURE;
    }

    // Decrypt ciphertext
    unsigned char plaintext[RSA_size(rsa)];
    int plaintext_length = RSA_private_decrypt(ciphertext_length, ciphertext, plaintext, rsa, RSA_PKCS1_OAEP_PADDING);
    if (plaintext_length == -1) {
        fprintf(stderr, "Error decrypting ciphertext\n");
        ERR_print_errors_fp(stderr);
        return EXIT_FAILURE;
    }

    // Print decrypted message
    printf("Decrypted message: %s\n", plaintext);

    // Free resources
    RSA_free(rsa);
    RSA_free(rsa_pub);

    return EXIT_SUCCESS;
}