//Falcon-180B DATASET v1.0 Category: Threading Library Implementation ; Style: Sherlock Holmes
#include <stdio.h>
#include <stdlib.h>
#include <pthread.h>

/* Define the number of threads */
#define NUM_THREADS 4

/* Define the stack size for each thread */
#define STACK_SIZE 4096

/* Define the structure for passing data to threads */
typedef struct {
    int thread_id;
    char *message;
} thread_data_t;

/* Function to be executed by each thread */
void *print_message(void *arg) {
    thread_data_t *data = (thread_data_t *) arg;
    printf("Thread %d says: %s\n", data->thread_id, data->message);
    return NULL;
}

/* Main function */
int main() {
    /* Initialize the thread IDs */
    int thread_ids[NUM_THREADS] = {1, 2, 3, 4};
    
    /* Initialize the messages to be printed by each thread */
    char *messages[NUM_THREADS] = {"Elementary, my dear Watson!",
                                    "The game is afoot!",
                                    "When you have eliminated the impossible, whatever remains, however improbable, must be the truth.",
                                    "It is a capital mistake to theorize before one has data."};
    
    /* Create an array of thread data structures */
    thread_data_t thread_data[NUM_THREADS];
    
    /* Fill in the thread data structures */
    for (int i = 0; i < NUM_THREADS; i++) {
        thread_data[i].thread_id = thread_ids[i];
        thread_data[i].message = messages[i];
    }
    
    /* Create the threads */
    pthread_t threads[NUM_THREADS];
    for (int i = 0; i < NUM_THREADS; i++) {
        pthread_create(&threads[i], NULL, print_message, &thread_data[i]);
    }
    
    /* Wait for the threads to finish */
    for (int i = 0; i < NUM_THREADS; i++) {
        pthread_join(threads[i], NULL);
    }
    
    return 0;
}