//GPT-4o-mini DATASET v1.0 Category: Packet Capturer with pcap library ; Style: cheerful
#include <pcap.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <arpa/inet.h>
#include <netinet/ip.h>
#include <netinet/tcp.h>
#include <netinet/ether.h>

#define SNAP_LEN 1518
#define FILTER_EXP "tcp"

// The packet handler function
void packet_handler(u_char *args, const struct pcap_pkthdr *header, const u_char *packet) {
    struct ether_header *eth_header = (struct ether_header *)packet;
    struct ip *ip_header = (struct ip *)(packet + sizeof(struct ether_header));
    struct tcphdr *tcp_header = (struct tcphdr *)(packet + sizeof(struct ether_header) + sizeof(struct ip));
    
    // Print out the details of the packet
    printf("---- New Packet Captured! ----\n");
    printf("Source MAC Address: %s\n", ether_ntoa((struct ether_addr *)eth_header->ether_shost));
    printf("Destination MAC Address: %s\n", ether_ntoa((struct ether_addr *)eth_header->ether_dhost));
    printf("Source IP Address: %s\n", inet_ntoa(ip_header->ip_src));
    printf("Destination IP Address: %s\n", inet_ntoa(ip_header->ip_dst));
    printf("Source Port: %d\n", ntohs(tcp_header->source));
    printf("Destination Port: %d\n", ntohs(tcp_header->dest));
    printf("---------------------------------\n");
}

int main(int argc, char *argv[]) {
    char *dev;           // Device name
    char errbuf[PCAP_ERRBUF_SIZE]; // Error buffer
    pcap_t *handle;     // Packet capture handle
    struct bpf_program fp; // BPF filter program
    char filter_exp[] = FILTER_EXP; // Filter expression for packet filtering

    // Find the default network interface
    if (argc == 2) {
        dev = argv[1];
    } else {
        dev = pcap_lookupdev(errbuf);
        if (dev == NULL) {
            fprintf(stderr, "Couldn't find default device: %s\n", errbuf);
            exit(EXIT_FAILURE);
        }
    }
    
    // Open the device for packet capture
    handle = pcap_open_live(dev, SNAP_LEN, 1, 1000, errbuf);
    if (handle == NULL) {
        fprintf(stderr, "Could not open device %s: %s\n", dev, errbuf);
        return EXIT_FAILURE;
    }

    // Compile the filter
    if (pcap_compile(handle, &fp, filter_exp, 0, PCAP_NETMASK_UNKNOWN) == -1) {
        fprintf(stderr, "Could not parse filter %s: %s\n", filter_exp, pcap_geterr(handle));
        exit(EXIT_FAILURE);
    }

    // Set the filter
    if (pcap_setfilter(handle, &fp) == -1) {
        fprintf(stderr, "Could not install filter %s: %s\n", filter_exp, pcap_geterr(handle));
        exit(EXIT_FAILURE);
    }

    // Start capturing packets
    printf("Starting packet capture on device: %s\n", dev);
    pcap_loop(handle, 0, packet_handler, NULL); // Infinite loop capturing packets

    // Cleanup
    pcap_freecode(&fp);
    pcap_close(handle);
    printf("Packet capture stopped. Goodbye!\n");
    return 0;
}