//Falcon-180B DATASET v1.0 Category: Electronic Voting System ; Style: grateful
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#define MAX_CANDIDATES 100
#define MAX_VOTERS 1000
#define MAX_NAME_LENGTH 100

typedef struct candidate {
    char name[MAX_NAME_LENGTH];
    int votes;
} candidate;

typedef struct voter {
    char name[MAX_NAME_LENGTH];
    int voter_id;
} voter;

candidate candidates[MAX_CANDIDATES];
voter voters[MAX_VOTERS];

int num_candidates = 0;
int num_voters = 0;

void add_candidate(char* name) {
    strcpy(candidates[num_candidates].name, name);
    candidates[num_candidates].votes = 0;
    num_candidates++;
}

void add_voter(char* name, int voter_id) {
    strcpy(voters[num_voters].name, name);
    voters[num_voters].voter_id = voter_id;
    num_voters++;
}

int find_candidate_index(char* name) {
    for (int i = 0; i < num_candidates; i++) {
        if (strcmp(candidates[i].name, name) == 0) {
            return i;
        }
    }
    return -1;
}

int find_voter_index(char* name) {
    for (int i = 0; i < num_voters; i++) {
        if (strcmp(voters[i].name, name) == 0) {
            return i;
        }
    }
    return -1;
}

void vote(char* voter_name, int candidate_index) {
    int voter_id = find_voter_index(voter_name);
    if (voter_id!= -1) {
        candidates[candidate_index].votes++;
        printf("%s voted for %s\n", voter_name, candidates[candidate_index].name);
    } else {
        printf("%s is not registered to vote\n", voter_name);
    }
}

void display_results() {
    printf("\nElection Results:\n");
    for (int i = 0; i < num_candidates; i++) {
        printf("%s - %d votes\n", candidates[i].name, candidates[i].votes);
    }
}

int main() {
    // Add candidates
    add_candidate("John");
    add_candidate("Jane");
    add_candidate("Bob");

    // Add voters
    add_voter("Alice", 1);
    add_voter("Bob", 2);
    add_voter("Charlie", 3);

    // Vote
    vote("Alice", 0);
    vote("Bob", 1);
    vote("Charlie", 2);

    // Display results
    display_results();

    return 0;
}