//GEMINI-pro DATASET v1.0 Category: Building a FTP Client ; Style: realistic
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#define FTP_PORT 21
#define MAX_BUFFER_SIZE 1024

int main() {
    // Create a socket
    int sockfd = socket(AF_INET, SOCK_STREAM, 0);
    if (sockfd < 0) {
        perror("socket");
        return EXIT_FAILURE;
    }

    // Set up the server address
    struct sockaddr_in server_addr;
    memset(&server_addr, 0, sizeof(server_addr));
    server_addr.sin_family = AF_INET;
    server_addr.sin_port = htons(FTP_PORT);
    server_addr.sin_addr.s_addr = inet_addr("127.0.0.1");

    // Connect to the server
    if (connect(sockfd, (struct sockaddr *)&server_addr, sizeof(server_addr)) < 0) {
        perror("connect");
        return EXIT_FAILURE;
    }

    // Send the FTP command
    char *ftp_command = "USER anonymous\r\n";
    if (send(sockfd, ftp_command, strlen(ftp_command), 0) < 0) {
        perror("send");
        return EXIT_FAILURE;
    }

    // Receive the server response
    char buffer[MAX_BUFFER_SIZE];
    if (recv(sockfd, buffer, MAX_BUFFER_SIZE, 0) < 0) {
        perror("recv");
        return EXIT_FAILURE;
    }

    // Print the server response
    printf("%s", buffer);

    // Close the socket
    close(sockfd);

    return EXIT_SUCCESS;
}