//LLAMA2-13B DATASET v1.0 Category: Pattern printing ; Style: protected
#include <stdio.h>

// Define the pattern dimensions and colors
#define PATTERN_WIDTH 10
#define PATTERN_HEIGHT 10
#define COLOR_DIAMOND 1
#define COLOR_TRIANGLE 2

// Define the pattern elements
void diamond(int row, int col) {
  if (row == 0 || col == 0) {
    printf(" "); // Top-left corner
  } else if (row == PATTERN_HEIGHT - 1 && col == 0) {
    printf(" "); // Bottom-left corner
  } else if (row == 0 && col == PATTERN_WIDTH - 1) {
    printf(" "); // Top-right corner
  } else if (row == PATTERN_HEIGHT - 1 && col == PATTERN_WIDTH - 1) {
    printf(" "); // Bottom-right corner
  } else {
    printf("X"); // Diamond
  }
}

void triangle(int row, int col) {
  if (row == 0 || col == 0) {
    printf(" "); // Top-left corner
  } else if (row == PATTERN_HEIGHT - 1 && col == 0) {
    printf(" "); // Bottom-left corner
  } else if (row == 0 && col == PATTERN_WIDTH - 1) {
    printf(" "); // Top-right corner
  } else if (row == PATTERN_HEIGHT - 1 && col == PATTERN_WIDTH - 1) {
    printf(" "); // Bottom-right corner
  } else {
    printf("O"); // Triangle
  }
}

// Define the main pattern printing function
void print_pattern(void) {
  int row, col;

  // Initialize the pattern with spaces
  for (row = 0; row < PATTERN_HEIGHT; row++) {
    for (col = 0; col < PATTERN_WIDTH; col++) {
      printf(" ");
    }
    printf("\n");
  }

  // Print the diamond and triangle patterns
  for (row = 1; row < PATTERN_HEIGHT - 1; row++) {
    for (col = 1; col < PATTERN_WIDTH - 1; col++) {
      diamond(row, col);
      triangle(row, col);
    }
    printf("\n");
  }

  // Print the remaining diamonds and triangles
  for (row = 1; row < PATTERN_HEIGHT - 1; row++) {
    for (col = 1; col < PATTERN_WIDTH - 1; col++) {
      if (row % 2 == 0 && col % 2 == 0) {
        diamond(row, col);
      } else {
        triangle(row, col);
      }
    }
    printf("\n");
  }
}

int main(void) {
  print_pattern();
  return 0;
}