//Gemma-7B DATASET v1.0 Category: Remote control Vehicle Simulation ; Style: imaginative
#include <stdio.h>
#include <stdlib.h>

#define MAX_SPEED 5

typedef struct Vehicle {
    char name[20];
    int x_position;
    int y_position;
    int current_speed;
    int direction;
} Vehicle;

Vehicle create_vehicle(char *name, int x_position, int y_position, int current_speed, int direction) {
    Vehicle vehicle;
    strcpy(vehicle.name, name);
    vehicle.x_position = x_position;
    vehicle.y_position = y_position;
    vehicle.current_speed = current_speed;
    vehicle.direction = direction;
    return vehicle;
}

void move_vehicle(Vehicle *vehicle, int direction, int speed) {
    switch (direction) {
        case 0:
            vehicle->x_position++;
            break;
        case 1:
            vehicle->y_position++;
            break;
        case 2:
            vehicle->x_position--;
            break;
        case 3:
            vehicle->y_position--;
            break;
    }

    vehicle->current_speed = speed;
}

int main() {
    Vehicle my_vehicle = create_vehicle("My Awesome Car", 10, 10, 2, 0);

    move_vehicle(&my_vehicle, 0, 3);
    move_vehicle(&my_vehicle, 1, 2);
    move_vehicle(&my_vehicle, 2, 1);
    move_vehicle(&my_vehicle, 3, 0);

    printf("Name: %s\n", my_vehicle.name);
    printf("Position: (%d, %d)\n", my_vehicle.x_position, my_vehicle.y_position);
    printf("Speed: %d\n", my_vehicle.current_speed);
    printf("Direction: %d\n", my_vehicle.direction);

    return 0;
}