//Falcon-180B DATASET v1.0 Category: Bucket Sort Implementation ; Style: invasive
#include <stdio.h>
#include <stdlib.h>

#define MAX 100

void bucketSort(int arr[], int n) {
    int i, j, max, min, range, bucket[MAX];

    max = arr[0];
    min = arr[0];

    for (i = 1; i < n; i++) {
        if (arr[i] > max) {
            max = arr[i];
        }
        if (arr[i] < min) {
            min = arr[i];
        }
    }

    range = max - min + 1;

    for (i = 0; i < MAX; i++) {
        bucket[i] = 0;
    }

    for (i = 0; i < n; i++) {
        j = (arr[i] - min) / range * MAX;
        bucket[j]++;
    }

    for (i = 1; i < MAX; i++) {
        bucket[i] += bucket[i - 1];
    }

    for (i = n - 1; i >= 0; i--) {
        j = (arr[i] - min) / range * MAX;
        bucket[j]--;
        arr[bucket[j]] = arr[i];
    }
}

int main() {
    int arr[] = { 5, 2, 8, 1, 6, 7, 3, 4 };
    int n = sizeof(arr) / sizeof(arr[0]);

    printf("Unsorted array:\n");
    for (int i = 0; i < n; i++) {
        printf("%d ", arr[i]);
    }
    printf("\n");

    bucketSort(arr, n);

    printf("Sorted array:\n");
    for (int i = 0; i < n; i++) {
        printf("%d ", arr[i]);
    }
    printf("\n");

    return 0;
}